@php
    $setting = App\Models\Setting::first();
@endphp
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>{{ $setting->site_name }} | Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="shortcut icon" type="image/png" href="{{ asset($setting->site_favicon) }}" />
</head>

<style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@100;300&display=swap');

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Poppins', sans-serif;
        background: url('admin_html/img/tek-wire-banner.jpg') no-repeat center center/cover;
        height: 100vh;
        overflow: hidden;
        color: white;
    }

    .container {
        display: flex;
        justify-content: end;
        align-items: center;
        height: 100%;
        padding: 0 5%;
    }



    .form_wrapper {
        display: flex;
        justify-content: center;
        align-items: center;
        margin-right: 100px;
    }


    .form_div {
        width: 600px;
        height: 500px;
        background: #fff;
        padding: 2rem;
        border-radius: 20px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        display: flex;
        justify-content: center;
        align-items: center;
        border: 2px solid #e7c0fb;
    }

    .headline {
        font-size: 24px;
        font-weight: 600;
        margin-bottom: 1em;
        text-transform: capitalize;
        text-align: center;
        color: #a349df;
    }


    .box {
        margin-bottom: 1em;
    }

    .box p {
        font-size: 14px;
        margin-bottom: 5px;
        color: #692bc9;
        font-weight: 600;
    }

    .box input {
        width: 100%;
        height: 45px;
        border: 1px solid #4922b3;
        outline: none;
        padding: 0 12px;
        border-radius: 12px;
        background: #fff;
        color: #000;
        transition: border 0.3s ease;
    }

    .box input:focus {
        border: 1px solid #4922b3;
        box-shadow: 0 0 6px rgba(37, 99, 235, 0.3);
    }


    .box div {
        position: relative;
    }



    .box input:focus::placeholder {
        color: #fff;
    }

    .loginBtn {
        width: 100%;
        height: 45px;
        border: none;
        border-radius: 12px;
        background: linear-gradient(to right, #916ca6, #6728cb);
        /* blue gradient */
        color: #fff;
        cursor: pointer;
        font-weight: bold;
        margin-top: 1em;
        transition: all 0.3s ease;
    }

    .loginBtn:hover {
        box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3);
        transform: translateY(-2px);
    }



    .text {
        font-size: 13px;
        margin-top: 1em;
        text-align: center;
        color: rgba(255, 255, 255, 0.7);
    }

    .text a {
        color: #fff;
        text-decoration: underline;
        margin-left: 5px;
    }



    .form_inner {
        width: 100%;
        padding: 0 20px;
    }


    p.error_message {
        font-size: 12px;
        color: #ff4263;
        text-align: center;
    }

    .logo-container-center {
        text-align: center;
        margin-top: 30px;
    }

    .logo-container-center img {
        max-width: 200px;

        height: auto;
        /* background: #152956ad; */
        padding: 10px;
        border-radius: 10px;
    }


    .logo-flex-center {
        display: flex;
        justify-content: center;
        margin-top: 30px;
    }

    .logo-flex-center img {
        max-width: 200px;
        height: auto;
    }
</style>



<body>


    <div class="container">


        <div class="form_wrapper">
            <form action="{{ route('admin.authenticate') }}" method="POST" class="form_div">
                {{ csrf_field() }}
                <div class="form_inner">
                    <p class="headline">Login</p>

                    <div class="box">
                        <p>Email</p>
                        <div>
                            <input type="text" name="email" placeholder="Enter your Email">
                        </div>
                    </div>

                    <div class="box">
                        <p>Password</p>
                        <div>
                            <input type="password" name="password" placeholder="Enter your Password">
                        </div>
                    </div>
                    <p class="error_message">{{ $errors->first('email') }} {{ $errors->first('password') }}</p>
                    <button type="submit" class="loginBtn">Login</button>


                </div>
            </form>
        </div>

    </div>

</body>

</html>
